<?php
/**
 * The template for displaying related room in single room page.
 *
 * This template can be overridden by copying it to yourtheme/wp-hotel-booking/single-room/related-room.php.
 *
 * @author  ThimPress, leehld
 * @package WP-Hotel-Booking/Templates
 * @version 1.6
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

$room                       = WPHB_Room::instance( get_the_ID() );
$related                    = apply_filters( 'vamtam_related_rooms', $room->get_related_rooms(), $room );
$vamtam_room_column_numbers = 'room-column-3';

/**
 * @var $related WP_Query
 */
?>

<?php if ( isset( $related->posts ) ) { ?>
	<div class="vamtam-related-rooms">
		<div class="limit-wrapper vamtam-box-outer-padding">
			<div class="related-room-title">
				<h3 class="title"><?php _e( 'Other Rooms', 'gast' ); ?></h3>
			</div>
			<div id="vamtam-hb-room-archive">
				<?php while ( $related->have_posts() ) : $related->the_post(); ?>
					<?php include( __DIR__ . '/../content-room.php' ); ?>
				<?php endwhile; ?>
			</div>
			<?php wp_reset_postdata(); ?>
		</div>
	</div>
<?php } ?>
