<?php
/**
 * The template for displaying single room gallery.
 *
 * This template can be overridden by copying it to yourtheme/wp-hotel-booking/single-room/gallery.php.
 *
 * @author  ThimPress, leehld
 * @package WP-Hotel-Booking/Templates
 * @version 1.6
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

global $hb_room;
/**
 * @var $hb_room WPHB_Room
 */
$galleries = $hb_room->get_galleries( false );
?>

<?php if ( $galleries ) : ?>
	<?php
		if ( VamtamTemplates::early_cube_load() ) {
			wp_enqueue_script( 'cubeportfolio' );
		}

		wp_enqueue_style( 'cubeportfolio' );

		$slider_options = array(
			'layoutMode'       => 'slider',
			'drag'             => true,
			'auto'             => false,
			'autoTimeout'      => 5000,
			'autoPauseOnHover' => true,
			'showNavigation'   => true,
			'showPagination'   => true,
			'rewindNav'        => true,
			'gridAdjustment'   => 'responsive',
			'mediaQueries'     => array(
				array(
					'width' => 1,
					'cols'  => 1,
				),
			),
			'gapHorizontal' => 0,
			'gapVertical'   => 0,
			'caption'       => '',
			'displayType'   => 'default',
		);

	?>
	<div class="vamtam-hb-room-gallery vamtam-cubeportfolio cbp cbp-slider-edge" data-options="<?php echo esc_attr( json_encode( $slider_options ) ) ?>">
		<?php foreach ( $galleries as $attachment ) : ?>
			<div class="cbp-item">
				<div class="cbp-caption">
					<div class="cbp-caption-defaultWrap">
						<?php echo wp_get_attachment_image( $attachment['id'], 'full' ) ?>
					</div>
				</div>
			</div>
		<?php endforeach ?>

		<?php
		if ( $hb_room->is_preview ) :
			$preview = get_post_meta( $hb_room->ID, '_hb_room_preview_url', true );
			?>
			<div class="cbp-item">
				<div class="cbp-caption">
					<div class="cbp-caption-defaultWrap">
						<?php
							global $wp_embed;
							echo $wp_embed->run_shortcode('[embed]'.$preview.'[/embed]'); // xss ok
						?>
					</div>
				</div>
			</div>
		<?php endif; ?>
	</div>

<?php
	else :
		the_post_thumbnail();
	endif;
?>
