<?php
/**
 * The template for displaying single room details.
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

$room = WPHB_Room::instance( get_the_ID() );

$tabsInfo = [];

$faqs = get_post_meta( $room->ID, '_wphb_room_faq', true );
if ( ! empty( $faqs ) ) {
	$tabsInfo[] = array(
		'id'      => 'hb_room_faq',
		'title'   => __( 'FAQS', 'wp-hotel-booking' ),
		'content' => $room->content_faqs,
	);
}

$rules = get_post_meta( $room->ID, '_hb_wphb_rule_room', true );
if ( ! empty( $rules ) ) {
	$tabsInfo[] = array(
		'id'      => 'hb_room_rule',
		'title'   => __( 'Room Rules', 'wp-hotel-booking' ),
		'content' => wpautop( $rules ),
	);
}

$tabs = apply_filters( 'hotel_booking_single_room_infomation_tabs', $tabsInfo );

// prepend after li tabs single
do_action( 'hotel_booking_before_single_room_infomation' );
?>

<div id="vamtam-single-room-detail">
	<div class="limit-wrapper vamtam-box-outer-padding">
		<div class="fl-module fl-module-vamtam-accordion fl-node-singleroomaccordion  vamtam-single-room-detail-accordion" data-node="singleroomaccordion">
			<div class="fl-module-content fl-node-content">
				<div class="fl-accordion fl-accordion-small fl-accordion-collapse">
					<?php foreach ( $tabs as $key => $tab ) : ?>
					<div class="fl-accordion-item">
						<div class="fl-accordion-button">
							<span class="fl-accordion-button-label">
							<?php printf( '%s', $tab['title'] ) ?>
							</span>
							<i class="fl-accordion-button-icon vamtam-theme-plus"></i>
						</div>
						<div class="fl-accordion-content fl-clearfix">
							<?php do_action( 'hotel_booking_single_room_before_tabs_content_' . $tab['id'] ); ?>

							<?php printf( '%s', $tab['content'] ); ?>

							<?php do_action( 'hotel_booking_single_room_after_tabs_content_' . $tab['id'] ); ?>
						</div>
					</div>
					<?php endforeach; ?>
				</div>
			</div>
		</div>
	</div>
</div>

