<?php
/**
 * Vamtam WP Hotel Booking setting helper
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit;

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

class VamtamHotelBookingSettingsHelper {

	/**
	 * The unique instance of the plugin.
	 *
	 * @var VamtamHotelBookingSettingsHelper
	 */
	private static $instance;

	/**
	 * Gets an instance of our plugin.
	 *
	 * @return VamtamHotelBookingSettingsHelper
	 */
	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}


	/**
	 *
	 * VamtamHotelBookingSettingsHelper constructor.
	 */
	public function __construct() {
		add_filter( 'hotel_booking_admin_setting_fields_room', array(
			$this,
			'limit_hotel_booking_catalog_number_column'
		) );

		add_filter( 'hotel_booking_admin_setting_fields_room', array(
			$this,
			'vamtam_archive_page_listing_word_number'
		), 0 );

		add_action( 'hb_update_meta_box_gallery_settings', [ $this, 'fix_gallery_ids' ] );
	}

	/**
	 * Limit hotel booking catalog number column number
	 * @param $settings_arr
	 *
	 * @return mixed
	 */
	public function limit_hotel_booking_catalog_number_column( $settings_arr ) {
		if ( ! empty( $settings_arr ) ) {

			foreach ( $settings_arr as $key => $settings ) {
				if ( $settings['id'] == 'tp_hotel_booking_catalog_number_column' ) {
					$settings_arr[ $key ] ['min'] = 2;
					$settings_arr[ $key ] ['max'] = 3;
				}

			}
		}

		return $settings_arr;
	}

	/**
	 * Add a settings to set the word number as room description on catalog page
	 * @param $settings_arr
	 *
	 * @return mixed
	 */
	public function vamtam_archive_page_listing_word_number( $settings_arr ) {
		$settings_field_array = array(
			'id'		=> 'tp_hotel_booking_catalog_word_number',
			'type'		=> 'number',
			'default'	=> 20,
			'title'		=> esc_html__( 'Word number as room description on catalog page', 'gast' ),
			'min'       => 10,
			'max'       => 40
		);

		$section_end_element = array_pop( $settings_arr );
		array_push( $settings_arr, $settings_field_array);
		array_push( $settings_arr, $section_end_element );

		return $settings_arr;
	}

	/**
	 * Fix gallery ids
	 */
	public function fix_gallery_ids( $post_id ) {
		if ( get_post_type( $post_id ) !== 'hb_room' ) {
			return;
		}

		if ( ! empty( $_POST['_hb_gallery'] ) && is_array( $_POST['_hb_gallery'] ) ) {
			update_post_meta( $post_id, '_hb_gallery', array_map( 'sanitize_text_field', $_POST['_hb_gallery'] ) );
		}
	}

}

VamtamHotelBookingSettingsHelper::get_instance();