<?php

/**
 * Theme options / General / Posts
 *
 * @package vamtam/gast
 */

return array(

	array(
		'label'       => esc_html__( 'Pagination Type', 'gast' ),
		'description' => esc_html__( 'Also used for portfolio', 'gast' ),
		'id'          => 'pagination-type',
		'type'        => 'select',
		'choices'     => array(
			'paged'              => esc_html__( 'Paged', 'gast' ),
			'load-more'          => esc_html__( 'Load more button', 'gast' ),
			'infinite-scrolling' => esc_html__( 'Infinite scrolling', 'gast' ),
		),
	),

	array(
		'label'       => esc_html__( 'Show "Related Posts" in Single Post View', 'gast' ),
		'description' => esc_html__( 'Enabling this option will show more posts from the same category when viewing a single post.', 'gast' ),
		'id'          => 'show-related-posts',
		'type'        => 'switch',
		'transport'   => 'postMessage',
	),

	array(
		'label'     => esc_html__( '"Related Posts" title', 'gast' ),
		'id'        => 'related-posts-title',
		'type'      => 'text',
		'transport' => 'postMessage',
	),

	array(
		'label'     => esc_html__( 'Meta Information', 'gast' ),
		'id'        => 'post-meta',
		'type'      => 'multicheck',
		'transport' => 'postMessage',
		'choices'   => array(
			'author'   => esc_html__( 'Post Author', 'gast' ),
			'tax'      => esc_html__( 'Categories and Tags', 'gast' ),
			'date'     => esc_html__( 'Timestamp', 'gast' ),
			'comments' => esc_html__( 'Comment Count', 'gast' ),
		),
	),

	array(
		'label'       => esc_html__( 'Show Featured Image on Single Posts', 'gast' ),
		'id'          => 'show-single-post-image',
		'description' => esc_html__( 'Please note, that this option works only for Blog Post Format Image.', 'gast' ),
		'type'        => 'switch',
		'transport'   => 'postMessage',
	),

	array(
		'label'       => esc_html__( 'Post Archive Layout', 'gast' ),
		'description' => '',
		'id'          => 'archive-layout',
		'type'        => 'radio',
		'choices'     => array(
			'normal' => esc_html__( 'Large', 'gast' ),
			'mosaic' => esc_html__( 'Small', 'gast' ),
		),
	),

);



