<?php
/**
 * @package vamtam/gast
 */
$room = WPHB_Room::hb_setup_room_data( $post );
?>

<div class="hb-room-container">
	<?php if ( $show_media ) : ?>
		<div class="post-media hb-room-media">
			<?php if ( isset( $post_data['media'] ) ) : ?>
				<div class="thumbnail">
					<?php if ( has_post_format( 'image' ) || ( isset( $post_data['act_as_image'] ) && $post_data['act_as_image'] ) ) : ?>
						<a href="https://live.ipms247.com/booking/book-rooms-hemaksuites" title="<?php the_title_attribute() ?>">
							<?php echo $post_data['media']; // xss ok ?>
							<?php echo vamtam_get_icon_html( array( // xss ok
								'name' => 'vamtam-theme-circle-post',
							) ); ?>
						</a>
					<?php else : ?>
						<?php echo $post_data['media']; // xss ok ?>
					<?php endif ?>
				</div>
			<?php endif; ?>
		</div>
	<?php endif ?>

	<?php if ( $show_content || $show_title ) : ?>
		<div class="post-content-wrapper hb-room-content">
			<?php if ( $show_title ) : ?>
				<?php include locate_template( 'templates/post/header-hb-room-module.php' ); ?>
			<?php endif ?>
			<p class="hb-room-desc">
				<?php echo vamtam_get_words( $room->addition_information ); ?>
			</p>
			<div class="post-footer-content">
				<?php $room_rent = vamtam_hb_minimum_room_rent( get_the_ID() ); ?>
				<?php if ( ! empty( $room_rent ) ) : ?>
					<div class="vamtam-pricing">
						<p>
							<?php esc_html_e( 'From: ', 'gast' ); ?>
							<span class="hb-room-rent"><?php echo hb_format_price( $room_rent ) ?></span>
							<?php esc_html_e( ' / Night', 'gast' ); ?>
						</p>
					</div>
				<?php endif ?>
				<div class="vamtam-rating-container">
					<?php do_action( 'hotel_booking_loop_room_rating' ); ?>
				</div>
				<a href="https://live.ipms247.com/booking/book-rooms-hemaksuites" class="button hb-room-footer-button">Book Now</a>
			</div>
		</div>
	<?php endif; ?>
	<div class="hb-room-title">
		<?php the_title(); ?>
	</div>
</div>
