<?php

namespace QuadLayers\QLWAPP_PRO;

class Helpers {
	protected static $instance;

	public function parse_args( $args ) {
		$model = array();

		foreach ( $args as $key => $value ) {
			$model[ str_replace( '-', '_', $key ) ] = $value;
		}

		return $model;
	}

	public function get_class_instance( $class_name ) {
		if ( method_exists( $class_name, 'instance' ) ) {
			return $class_name::instance();
		} else {
			return new $class_name();
		}
	}

	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}
}
