(function () {

    var Icons = Backbone.Model.extend({
      defaults: {
        icon: 'qlwapp-whatsapp-icon'
      }
    });
  
    var IconsView = Backbone.View.extend({
      events: {
        'click .icons .attachment': 'select',
        'click .media-modal-backdrop': 'close',
        'click .media-modal-close': 'close',
        'submit .media-modal-form': 'submit'
      },
      templates: {},
      initialize: function () {
        _.bindAll(this, 'open', 'render', 'close', 'submit');
        this.init();
        this.open();
  
      },
      init: function () {
        this.templates.window = wp.template('qlwapp-modal-window');
      },
      current: function (e) {
        'use strict';
        var modal = this;
        if (modal.model.attributes.icon != '') {
          modal.el.querySelector('.' + modal.model.attributes.icon)?.closest('li').focus();
        }
      },
      select: function (e) {
        'use strict';
        
        this.model.set({
          icon: e.target.querySelector('i').getAttribute('class')
        });
  
        this.render();
        this.enable();
      },
      render: function () {
  
        var modal = this;
  
        modal.el.innerHTML = modal.templates.window(modal.model.attributes);
  
        this.current();
  
      },
      open: function (e) {
        this.render();
        document.body.classList.add('modal-open');
        document.body.appendChild(this.el);
      },
      close: function (e) {
        e.preventDefault();
        this.undelegateEvents();
        document.body.classList.remove('modal-open');
        this.remove();
        return;
      },
      enable: function (e) {
        this.el.querySelector('.media-modal-submit').disabled = false;
      },
      submit: function (e) {
        e.preventDefault();
        var modal = this;
  
        var input = document.querySelector('input[name="icon"]');
  
        if (input && modal.model.attributes.icon) {
          input.value = modal.model.attributes.icon;
        }
  
        modal.close(e);
      }
    });
  
    var IconsModal = Backbone.View.extend({
      initialize: function (e) {
        var button = e.target,
                icon = button.closest('tr').querySelector('input[name=icon]').value;
  
        var model = new Icons();
  
        model.set({
          icon: icon
        });
  
        new IconsView({
          model: model
        });
      },
    });
  
    document.getElementById('qlwapp_icon_add').addEventListener('click', function (e) {
      e.preventDefault();
      new IconsModal(e);
    });
  
  })();
  