/**
 * WordPress dependencies
 */
import { __ } from '@wordpress/i18n';
import { close } from '@wordpress/icons';
import { Icon, Popover } from '@wordpress/components';

export default function GoDaddyLaunchTooltip( props ) {
	const {
		tooltip,
		closeCallback,
	} = props;

	return (
		<Popover
			anchorRect={ tooltip.anchorRect }
			className={ `publish-guide-tooltip godaddy-styles${ ! tooltip.nextTooltip ? ' publish-guide-tooltip--next' : '' }` }
			noArrow={ false }
		>

			<p className="publish-guide-tooltip__label">
				<svg fill="none" height="16" viewBox="0 0 18 16" width="18" xmlns="http://www.w3.org/2000/svg">
					<path d="M15.5266 0.730524C13.6559 -0.433974 11.1932 -0.159034 8.99681 1.21948C6.80726 -0.158272 4.34306 -0.433974 2.47469 0.730524C-0.48083 2.57438 -0.840161 7.32376 1.67287 11.3374C3.52521 14.2978 6.42199 16.0312 9.00063 15.9992C11.5793 16.0312 14.476 14.2978 16.3284 11.3374C18.8384 7.32376 18.4821 2.57438 15.5266 0.730524ZM3.03161 10.4905C2.51329 9.67028 2.12232 8.77644 1.87199 7.83937C1.6494 7.02621 1.56431 6.18166 1.62023 5.34054C1.73237 3.85769 2.33736 2.70233 3.32304 2.08695C4.30872 1.47157 5.61178 1.43577 6.99951 1.98489C7.21046 2.06958 7.41696 2.1649 7.61823 2.2705C6.8469 2.972 6.17632 3.7765 5.62551 4.66118C4.09969 7.09833 3.63431 9.81117 4.16682 11.9726C3.74261 11.5153 3.36252 11.0191 3.03161 10.4905ZM16.13 7.83937C15.8794 8.77632 15.4884 9.67012 14.9704 10.4905C14.6396 11.0201 14.2595 11.5174 13.8352 11.9757C14.3112 10.0374 13.9878 7.66344 12.8205 5.4365C12.802 5.39967 12.776 5.36715 12.7441 5.34104C12.7122 5.31494 12.6751 5.29584 12.6353 5.28499C12.5955 5.27414 12.5538 5.27178 12.5131 5.27807C12.4723 5.28436 12.4333 5.29916 12.3986 5.3215L8.75955 7.59185C8.72638 7.61245 8.69761 7.63939 8.6749 7.67112C8.65218 7.70284 8.63597 7.73873 8.62718 7.77673C8.61839 7.81473 8.6172 7.85408 8.62368 7.89254C8.63016 7.931 8.64419 7.9678 8.66494 8.00083L9.19898 8.85307C9.21962 8.88618 9.2466 8.9149 9.27839 8.93758C9.31017 8.96025 9.34612 8.97644 9.38418 8.98521C9.42224 8.99399 9.46167 8.99517 9.50019 8.9887C9.53871 8.98223 9.57557 8.96824 9.60867 8.94751L11.9676 7.47685C12.0439 7.70533 12.1202 7.93 12.1774 8.16229C12.3999 8.97547 12.485 9.82 12.4291 10.6611C12.317 12.1447 11.712 13.3001 10.7263 13.9155C10.2179 14.2258 9.63537 14.3941 9.03953 14.4029H8.96324C8.36738 14.3943 7.78478 14.226 7.27645 13.9155C6.29 13.3001 5.68502 12.1447 5.57287 10.6611C5.51741 9.82001 5.60249 8.97554 5.82463 8.16229C6.33618 6.28117 7.39305 4.59284 8.86254 3.30933C9.49632 2.75373 10.2182 2.30718 10.9987 1.98794C12.3826 1.43882 13.688 1.47461 14.6744 2.08999C15.6608 2.70537 16.2651 3.86073 16.3772 5.34358C16.4339 6.18344 16.3504 7.02686 16.13 7.83937Z" fill="#2B2B2B" />
				</svg>
				{ __( 'Get Started', 'godaddy-launch' ) }
			</p>

			<h3 className="publish-guide-tooltip__title">
				{ tooltip.title }
			</h3>

			<div className="publish-guide-tooltip__description">
				{ tooltip.description }
			</div>

			<Icon
				className="publish-guide-tooltip__close"
				icon={ close }
				onClick={ closeCallback }
			/>

		</Popover>
	);
}
