<?php
/**
 * The template for displaying search room item loop v2.
 *
 * This template can be overridden by copying it to yourtheme/wp-hotel-booking/search/loop.php.
 *
 * @author  ThimPress, leehld
 * @package WP-Hotel-Booking/Templates
 * @version 1.6
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

global $hb_settings;
/**
 * @var $hb_settings WPHB_Settings
 */
$gallery         = $room->gallery;
$featured        = $gallery ? array_shift( $gallery ) : false;
$single_purchase = get_option( 'tp_hotel_booking_single_purchase' );
$custom_process  = get_option( 'tp_hotel_booking_custom_process' );
$w               = hb_settings()->get( 'catalog_image_width', 270 );
$h               = hb_settings()->get( 'catalog_image_height', 270 );
?>

<li class="hb-room clearfix">
	<div class="hb-room-media">
		<div class="thumbnail">
			<?php if ( $featured ) : ?>
				<a class="hb-room-gallery"
				   data-lightbox="hb-room-gallery[<?php echo esc_attr( $room->post->ID ); ?>]"
				   data-title="<?php echo esc_attr( $featured['alt'] ); ?>"
				   href="<?php echo esc_attr( $featured['src'] ); ?>">
					<?php $room->getImage( 'catalog' ); ?>
				</a>
			<?php else : ?>
				<a class="hb-room-gallery"
				   data-lightbox="hb-room-gallery[<?php echo esc_attr( $room->post->ID ); ?>]"
				   data-title="<?php echo esc_attr( $room->post->post_name ); ?>"
				   href="<?php echo get_the_post_thumbnail_url( $room->post->ID, 'full' ); ?>">
					<?php
					VamtamOverrides::unlimited_image_sizes();
					echo get_the_post_thumbnail( $room->post->ID, 'vamtam-loop-featured-4' );
					VamtamOverrides::limit_image_sizes();
					?>
				</a>
			<?php endif; ?>
		</div>
	</div>
	<div class="post-content-wrapper hb-room-content">
		<header class="single">
			<div class="content">
				<h3>
					<a href="<?php echo esc_url( get_permalink( $room->post->ID) ); ?>" title="<?php echo esc_attr( $room->post->post_title ) ?>" class="entry-title"><?php echo wp_kses_post( $room->post->post_title ) ?></a>
				</h3>
				<?php
				$room_types                     = get_the_terms( $room->post->ID, 'hb_room_type');
				$i                              = 0;
				if( !empty( $room_types )) :
					$total_room_types_with_the_room = count( $room_types );
				?>
					<div class="room-types">
						<?php
						foreach ( $room_types as $room_type ) :
							$i++;
							$term_archive_url = get_term_link( $room_type );
							$term_name        = $room_type->name;
							echo '<a href="'. $term_archive_url .'" rel="tag" alt="'.$term_name.'">'. $term_name .'</a>';
							if( $i !== $total_room_types_with_the_room ):
								echo '<span class="sep"></span>';
							endif;
						endforeach;
						?>
					</div>
				<?php
				endif;
				?>
			</div>
		</header>
		<p class="hb-room-desc"><?php echo vamtam_get_words( $room->addition_information ); ?></p>
		<div class="post-footer-content">
			<?php $room_rent = vamtam_hb_minimum_room_rent( $room->post->ID ); ?>
			<?php if ( ! empty( $room_rent ) ) : ?>
				<div class="vamtam-pricing">
					<p>
						<?php esc_html_e( 'From: ', 'gast' ); ?>
						<span class="hb-room-rent"><?php echo hb_format_price( $room_rent ); ?></span>
						<?php esc_html_e( ' / Night', 'gast' ); ?>
					</p>
				</div>
			<?php endif ?>
			<div class="vamtam-rating-container">
				<?php
				WPHB_Room::hb_setup_room_data( $room->post );
				do_action( 'hotel_booking_loop_room_rating' );
				?>
			</div>

			<a href="<?php echo esc_url( get_permalink( $room->post->ID ) ); ?>" class="button hb-room-footer-button"><?php esc_html_e( 'Select This Room', 'gast' ) ?></a>
		</div>
	</div>

	<?php if ( ( isset( $atts['gallery'] ) && $atts['gallery'] === 'true' ) || $hb_settings->get( 'enable_gallery_lightbox' ) ) { ?>
		<?php hb_get_template( 'loop/gallery-lightbox.php', array( 'room' => $room ) ); ?>
	<?php } ?>

	<div class="hb-room-title">
		<?php echo wp_kses_post( $room->name ) ?>
	</div>
</li>
