<?php
/**
 * The template for displaying loop room rating in archive room page.
 *
 * This template can be overridden by copying it to yourtheme/wp-hotel-booking/loop/rating.php.
 *
 * @author  ThimPress, leehld
 * @package WP-Hotel-Booking/Templates
 * @version 1.6
 */

/**
 * Prevent loading this file directly
 */
defined('ABSPATH') || exit();

if ( ! defined( 'VAMTAM_HB_STARS_PRINTED' ) ) :
	define( 'VAMTAM_HB_STARS_PRINTED', true );
?>
	<svg aria-hidden="true" style="position: absolute; width: 0; height: 0; overflow: hidden;" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
		<defs>
			<symbol id="icon-star-full" viewBox="0 0 32 32">
				<title>star-full</title>
				<path d="M32 12.408l-11.056-1.607-4.944-10.018-4.944 10.018-11.056 1.607 8 7.798-1.889 11.011 9.889-5.199 9.889 5.199-1.889-11.011 8-7.798z"></path>
			</symbol>

			<symbol id="icon-star-empty" viewBox="0 0 32 32">
				<title>star-empty</title>
				<path d="M32 12.408l-11.056-1.607-4.944-10.018-4.944 10.018-11.056 1.607 8 7.798-1.889 11.011 9.889-5.199 9.889 5.199-1.889-11.011 8-7.798zM16 23.547l-6.983 3.671 1.334-7.776-5.65-5.507 7.808-1.134 3.492-7.075 3.492 7.075 7.807 1.134-5.65 5.507 1.334 7.776-6.983-3.671z"></path>
			</symbol>
		</defs>
	</svg>
<?php
endif;

global $hb_room;
/**
 * @var $hb_room WPHB_Room
 */
$rating = $hb_room->average_rating();

$rating_full  = ceil( $rating );
$rating_empty = 5 - $rating_full;
?>

<?php if ( !empty( $rating ) && comments_open($hb_room->ID) ) : ?>
	<div class="rating">
		<?php for( $i = 0; $i < $rating_full; $i++) : ?>
			<svg class="icon-vamtam-rating icon-star-full"><use xlink:href="#icon-star-full"></use></svg>
		<?php endfor; ?>
		<?php if( !empty( $rating_empty ) ) : ?>
			<?php for( $i = 0; $i < $rating_empty; $i++) : ?>
				<svg class="icon-vamtam-rating icon-star-empty"><use xlink:href="#icon-star-empty"></use></svg>
			<?php endfor; ?>
		<?php endif; ?>
	</div>
<?php endif; ?>