<?php
/**
 * The template for displaying content single room.
 *
 * This template can be overridden by copying it to yourtheme/wp-hotel-booking/content-single-room.php.
 *
 * @author  ThimPress, leehld
 * @package WP-Hotel-Booking/Templates
 * @version 1.6
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit(); ?>

<?php
/**
 * hotel_booking_before_single_product hook
 */
do_action( 'hotel_booking_before_single_product' );

if ( post_password_required() ) {
	echo get_the_password_form();

	return;
}

$room = WPHB_Room::instance( get_the_ID() );

?>

<div id="room-<?php the_ID(); ?>" <?php post_class( 'hb_single_room' ); ?>>

	<?php
	/**
	 * hotel_booking_before_loop_room_summary hook
	 */
	do_action( 'hotel_booking_before_single_room' );
	?>
	<div class="summary entry-summary">
		<div class="single-room-top-meta-container">
			<div class="limit-wrapper vamtam-box-outer-padding">
					<div class="single-room-top-meta">
					<?php if( $room->vamtam_beds ) : ?>
						<div>
							<h6><?php esc_html_e( 'Beds', 'gast' ); ?></h6>
							<?php echo esc_html( $room->vamtam_beds ) ?>
						</div>
					<?php endif; ?>

					<?php if( $room->vamtam_room_size ) : ?>
						<div>
							<h6><?php esc_html_e( 'Room size', 'gast' ); ?></h6>
							<?php echo esc_html( $room->vamtam_room_size ) ?>
						</div>
					<?php endif; ?>

					<?php
					if( $room->capacity || $room->max_child ) : ?>
						<div>
							<h6><?php esc_html_e( 'Occupancy', 'gast' ); ?></h6>
							<?php echo esc_html( sprintf( '%d adults (%d children)', $room->capacity, $room->max_child ) ); ?>
						</div>
					<?php endif; ?>

					<?php if( $room->vamtam_room_view ) : ?>
						<div>
							<h6><?php esc_html_e( 'View', 'gast' ); ?></h6>
							<?php echo esc_html( $room->vamtam_room_view ) ?>
						</div>
					<?php endif; ?>
						<?php
							/**
							 * hotel_booking_loop_room_price hook
							 */
							do_action( 'hotel_booking_loop_room_price' );
						?>
					</div>
			</div>
		</div>

		<div class="limit-wrapper vamtam-box-outer-padding">
			<div class="single-room-additional-info">
				<?php echo get_post_meta( $room->ID, '_hb_room_addition_information', true ); ?>
			</div>
		</div>

		<div id="vamtam-hb-galary-container">
			<div class="limit-wrapper vamtam-box-outer-padding">
				<?php
				/**
				 * hotel_booking_single_room_gallery hook
				 */
				do_action( 'hotel_booking_single_room_gallery' );
				?>
			</div>
		</div>

			<?php echo $room->addition_information //xss ok - includes <script> tags ?>

			<?php
			/**
			 * hotel_booking_single_room_infomation hook
			 */
			do_action( 'hotel_booking_single_room_infomation' );
			?>

	</div>
	<?php
	/**
	 * hotel_booking_after_single_room hook
	 */
	do_action( 'hotel_booking_after_single_room' );
	?>

<?php
/**
 * hotel_booking_after_single_product hook
 */
do_action( 'hotel_booking_after_single_product' ); ?>
