<?php
/**
 * Hotel booking search page room item
 *
 * @package vamtam/gast
 */

global $post, $hb_room, $hb_settings;
WPHB_Room::hb_setup_room_data( $post );
if( empty( $vamtam_room_column_numbers ) ) {
	$vamtam_room_column_numbers = "room-column-" . $hb_settings->get( 'catalog_number_column', 2 );
}
?>

<div class="hb-room <?php echo esc_attr( $vamtam_room_column_numbers ) ?>">
	<div class="hb-room-media">
		<div class="thumbnail">
			<?php
			VamtamOverrides::unlimited_image_sizes();
			the_post_thumbnail( 'vamtam-loop-featured-4' );
			VamtamOverrides::limit_image_sizes();
			?>
		</div>
	</div>

	<div class="post-content-wrapper hb-room-content">
		<header class="single">
			<div class="content">
				<h3>
					<a href="<?php echo esc_url( get_permalink( $post->ID) ); ?>" title="<?php echo esc_attr( $post->post_title ) ?>" class="entry-title"><?php echo wp_kses_post( $post->post_title ) ?></a>
				</h3>
				<?php
				$room_types                     = get_the_terms( $post->ID, 'hb_room_type');
				$i                              = 0;
				if( !empty( $room_types )) :
					$total_room_types_with_the_room = count( $room_types );
				?>
					<div class="room-types">
						<?php
						foreach ( $room_types as $room_type ) :
							$i++;
							$term_archive_url = get_term_link( $room_type );
							$term_name        = $room_type->name;
							echo '<a href="'. $term_archive_url .'" rel="tag" alt="'.$term_name.'">'. $term_name .'</a>';
							if( $i !== $total_room_types_with_the_room ):
								echo '<span class="sep"></span>';
							endif;
						endforeach;
						?>
					</div>
				<?php
				endif;
				?>
			</div>
		</header>
		<p class="hb-room-desc"><?php echo vamtam_get_words( $hb_room->addition_information ); ?></p>
		<div class="post-footer-content">
			<?php $room_rent = vamtam_hb_minimum_room_rent( $hb_room->post->ID ); ?>
			<?php if ( ! empty( $room_rent ) ) : ?>
				<div class="vamtam-pricing">
					<p>
						<?php esc_html_e( 'From: ', 'gast' ); ?>
						<span class="hb-room-rent"><?php echo hb_format_price( $room_rent ); ?></span>
						<?php esc_html_e( ' / Night', 'gast' ); ?>
					</p>
				</div>
			<?php endif ?>
			<div class="vamtam-rating-container">
				<?php
				do_action( 'hotel_booking_loop_room_rating' );
				?>
			</div>

			<a href="<?php echo esc_url( get_permalink( $post->ID ) ); ?>" class="button hb-room-footer-button"><?php esc_html_e( 'Select This Room', 'gast' ) ?></a>
		</div>
	</div>

	<div class="hb-room-title">
		<?php echo wp_kses_post( $post->post_title ) ?>
	</div>
</div>
