<?php
/**
 * Wp Hotel Booking related functions
 *
 * @package vamtam/gast
 */

/**
 * @return bool whether hotel_booking is active
 */
function vamtam_has_hotel_booking() {
	if ( class_exists( 'WP_Hotel_Booking' ) ) {
		return true;
	}

	return false;
}

function vamtam_hb_metabox_room_settings( $fields) {
	$fields = array_merge( $fields, [
		[
			'name'   => 'vamtam_room_view',
			'label'  => esc_html__( 'View', 'gast' ),
			'type'   => 'text',
			'std'    => '',
		],
		[
			'name'   => 'vamtam_room_size',
			'label'  => esc_html__( 'Size', 'gast' ),
			'type'   => 'text',
			'std'    => '',
		],
		[
			'name'   => 'vamtam_beds',
			'label'  => esc_html__( 'Beds', 'gast' ),
			'type'   => 'text',
			'std'    => '',
		],
	] );

	return $fields;
}
add_filter( 'wpbh_meta_box_room_general_fields', 'vamtam_hb_metabox_room_settings' );

function vamtam_hotel_booking_room_get_data( $return, $key, $room ) {
	if ( strpos( $key, 'vamtam_' ) === 0 ) {
		$return = get_post_meta( $room->ID, '_hb_' . $key, true );
	}

	return $return;
}

add_filter( 'hotel_booking_room_get_data', 'vamtam_hotel_booking_room_get_data', 10, 3 );

function vamtam_hotel_booking_search_vars() {
	if ( isset( $_REQUEST['hotel-booking'] ) ) {
		if ( isset( $_REQUEST['check_in_date' ] ) ) {
			$_REQUEST['hb_check_in_date'] = strtotime( $_REQUEST['check_in_date' ] );
		}

		if ( isset( $_REQUEST['check_out_date' ] ) ) {
			$_REQUEST['hb_check_out_date'] = strtotime( $_REQUEST['check_out_date' ] );
		}
	}
}
add_action( 'init', 'vamtam_hotel_booking_search_vars', 100 );