<?php

/**
 * HB Room heade template
 *
 * @package vamtam/gast
 */

global $post;

$title = get_the_title();

	$link = has_post_format( 'link' ) ?
		get_post_meta( $post->ID, 'vamtam-post-format-link', true ) :
		get_permalink();
	?>
	<header class="single">
		<div class="content">
			<h3>
				<a href="<?php echo esc_url( get_permalink( $post->ID) ); ?>" title="<?php the_title_attribute()?>" class="entry-title"><?php the_title(); ?></a>
			</h3>

			<?php
			$room_types                     = get_the_terms( $post->ID, 'hb_room_type');
			if( !empty( $room_types )) :
				$total_room_types_with_the_room = count( $room_types );
				$i                              = 0;
			?>
				<div class="room-types">
					<?php
					foreach ( $room_types as $room_type ) :
						$i++;
						$term_archive_url = get_term_link( $room_type );
						$term_name        = $room_type->name;
						echo '<a href="'. $term_archive_url .'" rel="tag" alt="'.$term_name.'">'. $term_name .'</a>';
						if( $i !== $total_room_types_with_the_room ):
							echo '<span class="sep"></span>';
						endif;
					endforeach;
					?>
				</div>
			<?php
			endif;
			?>

		</div>
	</header>




