<?php
/**
 * List View Single Event
 * This file contains one event in the list view
 *
 * Override this template in your own theme by creating a file at [your-theme]/tribe-events/list/single-event.php
 *
 * @version 4.6.19
 *
 */
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

global $post;

?>

<div class="vamtam-event-thumb-box">
	<div class="vamtam-event-thumb">
		<?php
		VamtamOverrides::unlimited_image_sizes();
		echo tribe_event_featured_image( null, VAMTAM_THUMBNAIL_PREFIX . "loop-4" );
		VamtamOverrides::limit_image_sizes();
		?>
	</div>
	<div class="vamtam-event-date">
		<div class="vamtam-event-date-contents"><?php echo tribe_get_start_date( $post, false, "d M" ); ?></div>
	</div>
</div>

<div class="vamtam-event-detail">
	<div class="event-title">
		<!-- Event Title -->
		<?php do_action( 'tribe_events_before_the_event_title' ) ?>
		<h3 class="tribe-events-list-event-title">
			<a class="tribe-event-url" href="<?php echo esc_url( tribe_get_event_link() ); ?>" title="<?php the_title_attribute() ?>" rel="bookmark">
				<?php the_title() ?>
			</a>
		</h3>
		<?php do_action( 'tribe_events_after_the_event_title' ) ?>
	</div>
	<div class="event-desc">
		<?php echo tribe_post_excerpt( $post ); ?>
	</div>
</div>

<div class="vamtam-event-get-more">
	<a href="<?php the_permalink(); ?>"> <?php echo esc_html__( 'See more &#8594;', 'gast' ) ?></a>
</div>
